// File: Grapher.h
//
// Description: This file contains the definition of class
//              'TGraph'. An instance of this class can be used
//              to graphically depict tree and DAG data structures.
//
// Copyright 1992, 1994,  Mark Watson
//


#ifndef grapher_h
#define grapher_h

#include "applib.h"

//
// Define constants for the maximum number of nodes allowed
// in a tree and the maximum size for a node name.  We lose
// some generality by defining these limits statically, but
// the tree layout algorythm is easier to understand if the
// data structures are allocated statically.
//

const int MAX_NODES = 40;
const int TEXT_SIZE = 30;

typedef struct _node {
	char name[TEXT_SIZE];
	int x, y;
	int parent_id;
	int plot_node;      // used for sub-tree displays
	char *private_data; // used for application data
	int selectionFlag;  // 0=not selected,
			            // 1=a child node is selected,
			            // 2=this node selected,
			            // 3=a parent node is selected
} node;

typedef struct _tree {
	node nodes[MAX_NODES];
	int num;
	int parent_node;
} tree;

class TGraph {
  public:
	TGraph(TAppWindow * myWind = NULL, char * root_name = "no_name");
   ~TGraph();
    void add_child(char *name, char * parent);
	int name_to_id(char *name);
	void do_layout();
	void do_layout(int new_parent_node);
    void Draw();
    void setSelection(int node_id); // node_id=-1 for clear whole graph
	int closestNode(int x, int y);
	int TGraph::getSelectedNode();

    // Data access member functions:
    inline char * get_private_data(int node_index);
    inline void set_private_data(int node_index, char * data);
    inline int get_number_of_nodes() { return t.num; }
    inline void set_number_of_nodes(int num) { t.num = num; }
    inline int get_parent_id(int node)
    { return  t.nodes[node].parent_id; }
    inline void set_parent_id(int node_index, int parent_id)
    { t.nodes[node_index].parent_id = parent_id; }
    inline char * get_node_name(int node)
    { return t.nodes[node].name; }
    inline void set_node_name(int node, char *name)
    {
      for (int i=0; i<TEXT_SIZE; i++)
        t.nodes[node].name[i] = name[i];
    }
    inline void copy_node(int to_node, int from_node)
    {
      for (int i=0; i<TEXT_SIZE; i++)
        t.nodes[to_node].name[i] = t.nodes[from_node].name[i];
      t.nodes[to_node].parent_id     =
        t.nodes[from_node].parent_id;
      t.nodes[to_node].plot_node     =
        t.nodes[from_node].plot_node;
      t.nodes[to_node].private_data  =
        t.nodes[from_node].private_data;
      t.nodes[to_node].selectionFlag =
        t.nodes[from_node].selectionFlag;
    }

  private:
	TAppWindow *myWindow;
	tree t;
	int last_y;
	void init_tree(char *root_name);
	int get_children(char *name, int *child_list, int buf_size);
	void Y_layout(int node_id, int level);
	void X_layout(int node_id, int level);
	void set_selection_children(int node_id);
	void set_selection_parent(int node_id);
};

#endif grapher_h
